CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'pdv_vd_it_descontos') THEN 
			
		CREATE TABLE public.pdv_vd_it_descontos (
			cd_emp numeric(6) NOT NULL DEFAULT 0,
			cd_filial numeric(6) NOT NULL DEFAULT 0,
			cd_vd numeric(10) NOT NULL DEFAULT 0,
			cd_it numeric(6) NOT NULL DEFAULT 0,
			cd_desconto numeric(6) NOT NULL DEFAULT 0,
			quantity numeric(14,4) NOT NULL DEFAULT 0,
			partner_promotion_id varchar(60) NOT NULL DEFAULT ''::character varying,
			unit_price_with_discount numeric(14,4) NOT NULL DEFAULT 0,
			unit_discount numeric(14,4) NOT NULL DEFAULT 0,
			CONSTRAINT pdv_cupom_it_descontos PRIMARY KEY (cd_emp, cd_filial, cd_vd, cd_it, cd_desconto)
			);
		
		ALTER TABLE pdv_vd_it_descontos OWNER TO postgres;
		GRANT ALL ON TABLE pdv_vd_it_descontos TO postgres;
		
        RAISE NOTICE 'Tabela pdv_vd_it_descontos CRIADA com sucesso.';
    ELSE 
		RAISE NOTICE 'Tabela pdv_vd_it_descontos já EXISTE.'; 
    END IF; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();